/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.gun.GunItemManager;
import java.util.EnumMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public final class GunItemBuilder {
    private int count = 1;
    private int ammoCount = 0;
    private class_2960 gunId;
    private FireMode fireMode = FireMode.UNKNOWN;
    private boolean bulletInBarrel = false;
    private EnumMap<AttachmentType, class_2960> attachments = Maps.newEnumMap(AttachmentType.class);

    private GunItemBuilder() {
    }

    public static GunItemBuilder create() {
        return new GunItemBuilder();
    }

    public GunItemBuilder setCount(int count) {
        this.count = Math.max(count, 1);
        return this;
    }

    public GunItemBuilder setAmmoCount(int count) {
        this.ammoCount = Math.max(count, 0);
        return this;
    }

    public GunItemBuilder setId(class_2960 id) {
        this.gunId = id;
        return this;
    }

    public GunItemBuilder setFireMode(FireMode fireMode) {
        this.fireMode = fireMode;
        return this;
    }

    public GunItemBuilder setAmmoInBarrel(boolean ammoInBarrel) {
        this.bulletInBarrel = ammoInBarrel;
        return this;
    }

    public GunItemBuilder putAttachment(AttachmentType type, class_2960 attachmentId) {
        this.attachments.put(type, attachmentId);
        return this;
    }

    public GunItemBuilder putAllAttachment(EnumMap<AttachmentType, class_2960> attachments) {
        this.attachments = attachments;
        return this;
    }

    public class_1799 build() {
        String itemType = TimelessAPI.getCommonGunIndex(this.gunId).map(index -> index.getPojo().getItemType()).orElse(null);
        Preconditions.checkArgument((itemType != null ? 1 : 0) != 0, (Object)("Could not found gun id: " + String.valueOf(this.gunId)));
        AbstractGunItem gunItems = GunItemManager.getGunItemRegistryObject(itemType);
        Preconditions.checkArgument((gunItems != null ? 1 : 0) != 0, (Object)("Could not found gun item type: " + itemType));
        class_1799 gun = new class_1799((class_1935)gunItems, this.count);
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            iGun.setGunId(gun, this.gunId);
            iGun.setFireMode(gun, this.fireMode);
            iGun.setCurrentAmmoCount(gun, this.ammoCount);
            iGun.setBulletInBarrel(gun, this.bulletInBarrel);
            this.attachments.forEach((type, id) -> {
                class_1799 attachmentStack = AttachmentItemBuilder.create().setId((class_2960)id).build();
                iGun.installAttachment(gun, attachmentStack);
            });
        }
        return gun;
    }
}

